/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.models.modeldata;

import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.ferreusveritas.dynamictrees.util.Connections;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;

public class ModelConnections
extends Connections {
    public static final ModelProperty<ModelConnections> CONNECTIONS_PROPERTY = new ModelProperty();
    private Direction ringOnly = null;
    private Family family = Family.NULL_FAMILY;

    public ModelConnections() {
    }

    public ModelConnections(Connections connections) {
        this.setAllRadii(connections.getAllRadii());
    }

    public ModelConnections(int[] radii) {
        super(radii);
    }

    public ModelConnections(Direction ringDir) {
        this.ringOnly = ringDir;
    }

    @Override
    public ModelConnections setAllRadii(int[] radii) {
        return (ModelConnections)super.setAllRadii(radii);
    }

    public ModelConnections setFamily(Family family) {
        this.family = family;
        return this;
    }

    public ModelConnections setFamily(@Nullable BranchBlock branch) {
        if (branch != null) {
            this.family = branch.getFamily();
        }
        return this;
    }

    public Family getFamily() {
        return this.family;
    }

    public Direction getRingOnly() {
        return this.ringOnly;
    }

    public void setForceRing(Direction ringSide) {
        this.ringOnly = ringSide;
    }

    public ModelData toModelData() {
        return ModelData.builder().with(CONNECTIONS_PROPERTY, (Object)this).build();
    }

    public ModelData toModelData(ModelData baseData) {
        return baseData.derive().with(CONNECTIONS_PROPERTY, (Object)this).build();
    }
}

