/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.resources;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.api.configuration.ConfigurationTemplateResourceLoader;
import com.ferreusveritas.dynamictrees.api.event.Hooks;
import com.ferreusveritas.dynamictrees.api.resource.TreeResourceManager;
import com.ferreusveritas.dynamictrees.data.DTRecipes;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKit;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKitConfiguration;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.ferreusveritas.dynamictrees.resources.FlatTreeResourcePack;
import com.ferreusveritas.dynamictrees.resources.ModTreeResourcePack;
import com.ferreusveritas.dynamictrees.resources.TreesResourceManager;
import com.ferreusveritas.dynamictrees.resources.loader.BiomePopulatorsResourceLoader;
import com.ferreusveritas.dynamictrees.resources.loader.FamilyResourceLoader;
import com.ferreusveritas.dynamictrees.resources.loader.FeatureCancellationResourceLoader;
import com.ferreusveritas.dynamictrees.resources.loader.FruitResourceLoader;
import com.ferreusveritas.dynamictrees.resources.loader.JoCodeResourceLoader;
import com.ferreusveritas.dynamictrees.resources.loader.LeavesPropertiesResourceLoader;
import com.ferreusveritas.dynamictrees.resources.loader.PodResourceLoader;
import com.ferreusveritas.dynamictrees.resources.loader.SoilPropertiesResourceLoader;
import com.ferreusveritas.dynamictrees.resources.loader.SpeciesResourceLoader;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.locating.IModFile;
import org.apache.logging.log4j.LogManager;

@Mod.EventBusSubscriber(modid="dynamictrees")
public final class Resources {
    public static final ResourceLocation RESOURCE_LOCATION = DynamicTrees.location("registry_name");
    public static final String TREES = "trees";
    public static final TreeResourceManager MANAGER = new TreesResourceManager();
    public static final LeavesPropertiesResourceLoader LEAVES_PROPERTIES_LOADER = new LeavesPropertiesResourceLoader();
    public static final SoilPropertiesResourceLoader SOIL_PROPERTIES_LOADER = new SoilPropertiesResourceLoader();
    public static final FamilyResourceLoader FAMILY_LOADER = new FamilyResourceLoader();
    public static final ConfigurationTemplateResourceLoader<GenFeatureConfiguration, GenFeature> GEN_FEATURE_TEMPLATE_LOADER = new ConfigurationTemplateResourceLoader<GenFeatureConfiguration, GenFeature>("gen_features/configurations", GenFeature.REGISTRY, GenFeatureConfiguration.TEMPLATES);
    public static final ConfigurationTemplateResourceLoader<GrowthLogicKitConfiguration, GrowthLogicKit> GROWTH_LOGIC_KIT_TEMPLATE_LOADER = new ConfigurationTemplateResourceLoader<GrowthLogicKitConfiguration, GrowthLogicKit>("growth_logic_kits/configurations", GrowthLogicKit.REGISTRY, GrowthLogicKitConfiguration.TEMPLATES);
    public static final FruitResourceLoader FRUIT_LOADER = new FruitResourceLoader();
    public static final PodResourceLoader POD_LOADER = new PodResourceLoader();
    public static final SpeciesResourceLoader SPECIES_LOADER = new SpeciesResourceLoader();
    public static final JoCodeResourceLoader JO_CODE_LOADER = new JoCodeResourceLoader();
    public static final FeatureCancellationResourceLoader FEATURE_CANCELLATION_LOADER = new FeatureCancellationResourceLoader();
    public static final BiomePopulatorsResourceLoader BIOME_POPULATORS_LOADER = new BiomePopulatorsResourceLoader();
    private static ICondition.IContext conditionContext;

    public static void setupTreesResourceManager() {
        Resources.addDefaultLoaders();
        Hooks.onAddResourceLoaders(MANAGER);
        MANAGER.registerAppliers();
        Resources.registerModTreePacks();
        Resources.registerFlatTreePack();
        LogManager.getLogger().debug("Successfully loaded " + MANAGER.m_7536_().count() + " tree packs.");
    }

    private static void addDefaultLoaders() {
        MANAGER.addLoaders(LEAVES_PROPERTIES_LOADER, SOIL_PROPERTIES_LOADER, FAMILY_LOADER, GEN_FEATURE_TEMPLATE_LOADER, GROWTH_LOGIC_KIT_TEMPLATE_LOADER, FRUIT_LOADER, POD_LOADER, SPECIES_LOADER, JO_CODE_LOADER, FEATURE_CANCELLATION_LOADER, BIOME_POPULATORS_LOADER);
    }

    private static void registerModTreePacks() {
        ModList.get().getMods().forEach(Resources::addModResourcePack);
    }

    private static void addModResourcePack(IModInfo modInfo) {
        IModFile modFile = modInfo.getOwningFile().getFile();
        if (modFile.getProvider().isValid(modFile)) {
            Resources.addModResourcePack(modFile);
        }
    }

    private static void addModResourcePack(IModFile modFile) {
        Path treesPath = modFile.findResource(new String[]{TREES}).toAbsolutePath();
        if (Files.exists(treesPath, new LinkOption[0])) {
            MANAGER.addPack(new ModTreeResourcePack("treepack/" + ((IModInfo)modFile.getModInfos().get(0)).getModId(), true, treesPath, modFile));
        }
    }

    private static void registerFlatTreePack() {
        File mainTreeFolder = Resources.getTreeFolder();
        MANAGER.addPack(new FlatTreeResourcePack("treepack_flat", true, mainTreeFolder.toPath().toAbsolutePath()));
    }

    private static File getTreeFolder() {
        File mainTreeFolder = new File("trees/");
        if (!mainTreeFolder.exists() && !mainTreeFolder.mkdir()) {
            throw new RuntimeException("Failed to create \"trees\" folder in your Minecraft directory.");
        }
        return mainTreeFolder;
    }

    @SubscribeEvent
    public static void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new ReloadListener(event.getServerResources()));
        conditionContext = event.getConditionContext();
    }

    public static ICondition.IContext getConditionContext() {
        return conditionContext;
    }

    public static final class ReloadListener
    implements PreparableReloadListener {
        private final ReloadableServerResources dataPackRegistries;

        public ReloadListener(ReloadableServerResources dataPackRegistries) {
            this.dataPackRegistries = dataPackRegistries;
        }

        public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
            CompletableFuture[] futures = MANAGER.prepareReload(gameExecutor, backgroundExecutor);
            return ((CompletableFuture)((CompletableFuture)CompletableFuture.allOf(futures).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).m_6769_(arg_0))).thenAcceptAsync(v -> MANAGER.reload(futures), gameExecutor)).thenRunAsync(this::registerDirtBucketRecipes, gameExecutor);
        }

        private void registerDirtBucketRecipes() {
            if (!((Boolean)DTConfigs.GENERATE_DIRT_BUCKET_RECIPES.get()).booleanValue()) {
                return;
            }
            HashMap<RecipeType, Map> recipes = new HashMap<RecipeType, Map>();
            this.dataPackRegistries.m_206887_().f_44007_.forEach((recipeType, currentRecipes) -> recipes.put((RecipeType)recipeType, new HashMap(currentRecipes)));
            DTRecipes.registerDirtBucketRecipes((Map)recipes.get(RecipeType.f_44107_));
            recipes.forEach((recipeType, currentRecipes) -> recipes.put((RecipeType)recipeType, (Map)ImmutableMap.copyOf((Map)currentRecipes)));
            this.dataPackRegistries.m_206887_().f_44007_ = ImmutableMap.copyOf(recipes);
        }
    }
}

