/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.tree.species;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.TreeRegistry;
import com.ferreusveritas.dynamictrees.api.data.Generator;
import com.ferreusveritas.dynamictrees.api.data.SaplingStateGenerator;
import com.ferreusveritas.dynamictrees.api.data.SeedItemModelGenerator;
import com.ferreusveritas.dynamictrees.api.data.SpeciesLangGenerator;
import com.ferreusveritas.dynamictrees.api.event.Hooks;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.network.NodeInspector;
import com.ferreusveritas.dynamictrees.api.registry.RegistryEntry;
import com.ferreusveritas.dynamictrees.api.registry.RegistryHandler;
import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.api.substance.Emptiable;
import com.ferreusveritas.dynamictrees.api.substance.SubstanceEffect;
import com.ferreusveritas.dynamictrees.api.substance.SubstanceEffectProvider;
import com.ferreusveritas.dynamictrees.api.treedata.TreePart;
import com.ferreusveritas.dynamictrees.block.DynamicSaplingBlock;
import com.ferreusveritas.dynamictrees.block.PottedSaplingBlock;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.block.entity.SpeciesBlockEntity;
import com.ferreusveritas.dynamictrees.block.leaves.DynamicLeavesBlock;
import com.ferreusveritas.dynamictrees.block.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.block.rooty.RootyBlock;
import com.ferreusveritas.dynamictrees.block.rooty.SoilHelper;
import com.ferreusveritas.dynamictrees.block.rooty.SoilProperties;
import com.ferreusveritas.dynamictrees.compat.season.SeasonHelper;
import com.ferreusveritas.dynamictrees.data.DTBlockTags;
import com.ferreusveritas.dynamictrees.data.DTItemTags;
import com.ferreusveritas.dynamictrees.data.provider.DTBlockStateProvider;
import com.ferreusveritas.dynamictrees.data.provider.DTItemModelProvider;
import com.ferreusveritas.dynamictrees.data.provider.DTLangProvider;
import com.ferreusveritas.dynamictrees.data.provider.DTLootTableProvider;
import com.ferreusveritas.dynamictrees.entity.FallingTreeEntity;
import com.ferreusveritas.dynamictrees.entity.LingeringEffectorEntity;
import com.ferreusveritas.dynamictrees.entity.animation.AnimationHandler;
import com.ferreusveritas.dynamictrees.event.BiomeSuitabilityEvent;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKit;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKitConfiguration;
import com.ferreusveritas.dynamictrees.growthlogic.context.PositionalSpeciesContext;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.ferreusveritas.dynamictrees.init.DTRegistries;
import com.ferreusveritas.dynamictrees.init.DTTrees;
import com.ferreusveritas.dynamictrees.item.Seed;
import com.ferreusveritas.dynamictrees.loot.DTLootContextParams;
import com.ferreusveritas.dynamictrees.loot.DTLootParameterSets;
import com.ferreusveritas.dynamictrees.models.FallingTreeEntityModel;
import com.ferreusveritas.dynamictrees.resources.Resources;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.systems.SeedSaplingRecipe;
import com.ferreusveritas.dynamictrees.systems.fruit.Fruit;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeature.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.FullGenerationContext;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGrowContext;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostRotContext;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PreGenerationContext;
import com.ferreusveritas.dynamictrees.systems.nodemapper.DiseaseNode;
import com.ferreusveritas.dynamictrees.systems.nodemapper.FindEndsNode;
import com.ferreusveritas.dynamictrees.systems.nodemapper.InflatorNode;
import com.ferreusveritas.dynamictrees.systems.nodemapper.NetVolumeNode;
import com.ferreusveritas.dynamictrees.systems.nodemapper.ShrinkerNode;
import com.ferreusveritas.dynamictrees.systems.pod.Pod;
import com.ferreusveritas.dynamictrees.systems.substance.FertilizeSubstance;
import com.ferreusveritas.dynamictrees.systems.substance.GrowthSubstance;
import com.ferreusveritas.dynamictrees.tree.Resettable;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.ferreusveritas.dynamictrees.util.BranchDestructionData;
import com.ferreusveritas.dynamictrees.util.CommonVoxelShapes;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.LazyValue;
import com.ferreusveritas.dynamictrees.util.LevelContext;
import com.ferreusveritas.dynamictrees.util.MutableLazyValue;
import com.ferreusveritas.dynamictrees.util.Optionals;
import com.ferreusveritas.dynamictrees.util.ResourceLocationUtils;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import com.ferreusveritas.dynamictrees.util.holderset.DTBiomeHolderSet;
import com.ferreusveritas.dynamictrees.worldgen.DynamicTreeFeature;
import com.ferreusveritas.dynamictrees.worldgen.GenerationContext;
import com.ferreusveritas.dynamictrees.worldgen.JoCode;
import com.ferreusveritas.dynamictrees.worldgen.JoCodeRegistry;
import com.ferreusveritas.dynamictrees.worldgen.RootsJoCode;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function3;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;

public class Species
extends RegistryEntry<Species>
implements Resettable<Species> {
    public static final Species NULL_SPECIES = new Species(){

        @Override
        public Optional<Seed> getSeed() {
            return Optional.empty();
        }

        @Override
        public Family getFamily() {
            return Family.NULL_FAMILY;
        }

        @Override
        public boolean isTransformable() {
            return false;
        }

        @Override
        public boolean plantSapling(LevelAccessor level, BlockPos pos, boolean locationOverride) {
            return false;
        }

        @Override
        public boolean generate(GenerationContext context) {
            return false;
        }

        @Override
        public float biomeSuitability(Level level, BlockPos pos) {
            return 0.0f;
        }

        @Override
        public Species setSeed(Supplier<Seed> seedSup) {
            return this;
        }

        @Override
        public ItemStack getSeedStack(int qty) {
            return ItemStack.f_41583_;
        }

        @Override
        public Component getTextComponent() {
            return this.formatComponent((Component)Component.m_237115_((String)"gui.none"), ChatFormatting.DARK_RED);
        }

        @Override
        public boolean update(Level level, RootyBlock rootyDirt, BlockPos rootPos, int fertility, TreePart treeBase, BlockPos treePos, RandomSource random, boolean rapid) {
            return false;
        }
    };
    public static final TypedRegistry.EntryType<Species> TYPE = Species.createDefaultType((Function3<ResourceLocation, Family, LeavesProperties, Species>)((Function3)Species::new));
    public static final Codec<Species> CODEC = ResourceLocation.f_135803_.comapFlatMap(Species::read, RegistryEntry::getRegistryName);
    public static final TypedRegistry<Species> REGISTRY = new TypedRegistry<Species>(Species.class, NULL_SPECIES, TYPE);
    protected Family family = Family.NULL_FAMILY;
    protected GrowthLogicKitConfiguration logicKit = GrowthLogicKitConfiguration.getDefault();
    protected float tapering = 0.3f;
    protected int upProbability = 2;
    protected int lowestBranchHeight = 3;
    protected float signalEnergy = 16.0f;
    protected float growthRate = 1.0f;
    protected SoilProperties forceSoil;
    protected int soilLongevity = 8;
    protected int soilTypeFlags = 0;
    protected int worldGenSoilTypeFlags = 0;
    protected int maxBranchRadius = 8;
    private boolean transformable = true;
    protected final List<Block> acceptableBlocksForGrowth = Lists.newArrayList();
    protected LeavesProperties leavesProperties = LeavesProperties.NULL;
    private final List<LeavesProperties> validLeaves = new LinkedList<LeavesProperties>();
    protected Supplier<Seed> seed;
    protected Boolean dropSeeds = null;
    protected Supplier<DynamicSaplingBlock> saplingBlock;
    protected Boolean tintSapling = true;
    protected Map<TagKey<Biome>, Float> envFactors = new HashMap<TagKey<Biome>, Float>();
    protected DTBiomeHolderSet perfectBiomes = new DTBiomeHolderSet();
    protected final List<GenFeatureConfiguration> genFeatures = new ArrayList<GenFeatureConfiguration>();
    protected CommonOverride commonOverride;
    private String unlocalizedName = "";
    private Set<Fruit> fruits = new HashSet<Fruit>();
    private Set<Pod> pods = new HashSet<Pod>();
    private Boolean shouldGenerateSeed;
    private String seedName = null;
    protected final Set<SeedSaplingRecipe> primitiveSaplingRecipe = new HashSet<SeedSaplingRecipe>();
    private Boolean shouldGenerateSapling;
    private boolean canSaplingGrowNaturally = true;
    private VoxelShape saplingShape = CommonVoxelShapes.SAPLING;
    private String saplingName = null;
    private SoundType saplingSound = SoundType.f_56740_;
    private int allowedWaterHeightForWorldgen = 1;
    private boolean plantableOnFluid = false;
    private static final Direction[] upFirst = new Direction[]{Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
    private boolean doesRot = true;
    private boolean canBoneMealTree = true;
    protected float flowerSeasonHoldMin = 0.0f;
    protected float flowerSeasonHoldMax = 0.5f;
    @Nullable
    protected Float seasonalGrowthOffset = Float.valueOf(0.0f);
    @Nullable
    protected Float seasonalSeedDropOffset = Float.valueOf(0.0f);
    @Nullable
    protected Float seasonalFruitingOffset = Float.valueOf(0.0f);
    protected Boolean alwaysShowOnWaila = null;
    private Species megaSpecies = NULL_SPECIES;
    private Species preMegaSpecies = NULL_SPECIES;
    protected float bigTreeSoundThreshold = 20.0f;
    private int worldGenLeafMapHeight = 32;
    protected List<String> onlyIfLoaded = new ArrayList<String>();
    protected HashMap<String, ResourceLocation> textureOverrides = new HashMap();
    protected HashMap<String, String> langOverrides = new HashMap();
    protected HashMap<String, ResourceLocation> modelOverrides = new HashMap();
    public static final String SAPLING = "sapling";
    public static final String SEED_PARENT = "seed_parent";
    public static final String SEED = "seed";
    protected final MutableLazyValue<Generator<DTBlockStateProvider, Species>> saplingStateGenerator = MutableLazyValue.supplied(SaplingStateGenerator::new);
    protected final MutableLazyValue<Generator<DTLangProvider, Species>> speciesLangProvider = MutableLazyValue.supplied(SpeciesLangGenerator::new);
    protected final MutableLazyValue<Generator<DTItemModelProvider, Species>> seedModelGenerator = MutableLazyValue.supplied(SeedItemModelGenerator::new);
    private final LazyValue<ResourceLocation> voluntaryDropsPath = LazyValue.supplied(() -> ResourceLocationUtils.prefix(this.getRegistryName(), "trees/voluntary/"));

    public static TypedRegistry.EntryType<Species> createDefaultType(Function3<ResourceLocation, Family, LeavesProperties, Species> constructor) {
        return TypedRegistry.newType(Species.createDefaultCodec(constructor));
    }

    public static Codec<Species> createDefaultCodec(Function3<ResourceLocation, Family, LeavesProperties, Species> constructor) {
        return RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf(Resources.RESOURCE_LOCATION.toString()).forGetter(RegistryEntry::getRegistryName), (App)Family.REGISTRY.getGetterCodec().fieldOf("family").forGetter(Species::getFamily), (App)LeavesProperties.REGISTRY.getGetterCodec().optionalFieldOf("leaves_properties", (Object)LeavesProperties.NULL).forGetter(Species::getLeavesProperties)).apply((Applicative)instance, constructor));
    }

    private static DataResult<Species> read(ResourceLocation name) {
        Species species = (Species)REGISTRY.get(name);
        return species == null ? DataResult.error(() -> "Species not found: " + name) : DataResult.success((Object)species);
    }

    public Species() {
        this.setRegistryName(DTTrees.NULL);
    }

    public Species(ResourceLocation name, Family family) {
        this(name, family, family.getCommonLeaves());
    }

    public Species(ResourceLocation name, Family family, LeavesProperties leavesProperties) {
        this.setRegistryName(name);
        this.setUnlocalizedName(name.toString());
        this.family = family;
        this.family.addSpecies(this);
        this.setLeavesProperties(leavesProperties.isValid() ? leavesProperties : family.getCommonLeaves());
    }

    @Override
    public Species reset() {
        this.fruits.clear();
        this.pods.clear();
        this.envFactors.clear();
        this.genFeatures.clear();
        this.acceptableBlocksForGrowth.clear();
        this.primitiveSaplingRecipe.clear();
        this.perfectBiomes.clear();
        this.clearAcceptableSoils();
        return this;
    }

    @Override
    public Species setPreReloadDefaults() {
        return this.setDefaultGrowingParameters().setSaplingShape(CommonVoxelShapes.SAPLING).setSaplingSound(SoundType.f_56740_);
    }

    @Override
    public Species setPostReloadDefaults() {
        if (!this.hasSeed()) {
            this.seed = this.getCommonSpecies().seed;
        }
        if (!this.hasAcceptableSoil()) {
            this.setStandardSoils();
        }
        return this;
    }

    public Species setDefaultGrowingParameters() {
        return this;
    }

    public float defaultSeedComposterChance() {
        return 0.3f;
    }

    public Family getFamily() {
        return this.family;
    }

    public void setFamily(Family family) {
        family.addSpecies(this);
        this.family = family;
    }

    public Species getCommonSpecies() {
        return this.family.getCommonSpecies();
    }

    public boolean isCommonSpecies() {
        return this.getCommonSpecies() == this;
    }

    public boolean isSeedCommon() {
        return this.getCommonSpecies().getSeed().orElse(null) == this.seed.get();
    }

    public Species setUnlocalizedName(String name) {
        this.unlocalizedName = "species." + name.replace(":", ".");
        return this;
    }

    public String getLocalizedName() {
        return I18n.m_118938_((String)this.getUnlocalizedName(), (Object[])new Object[0]);
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    @Override
    public Component getTextComponent() {
        return this.formatComponent((Component)Component.m_237115_((String)this.getUnlocalizedName()), ChatFormatting.AQUA);
    }

    public Species setBasicGrowingParameters(float tapering, float energy, int upProbability, int lowestBranchHeight, float growthRate) {
        this.tapering = tapering;
        this.signalEnergy = energy;
        this.upProbability = upProbability;
        this.lowestBranchHeight = lowestBranchHeight;
        this.growthRate = growthRate;
        return this;
    }

    public void setTapering(float tapering) {
        this.tapering = tapering;
    }

    public void setUpProbability(int upProbability) {
        this.upProbability = upProbability;
    }

    public void setLowestBranchHeight(int lowestBranchHeight) {
        this.lowestBranchHeight = lowestBranchHeight;
    }

    public void setSignalEnergy(float signalEnergy) {
        this.signalEnergy = signalEnergy;
    }

    public void setGrowthRate(float growthRate) {
        this.growthRate = growthRate;
    }

    public float getSignalEnergy() {
        return this.signalEnergy;
    }

    public float getEnergy(Level level, BlockPos rootPos) {
        return this.logicKit.getEnergy(new PositionalSpeciesContext(level, rootPos, this));
    }

    public float getGrowthRate(Level level, BlockPos rootPos) {
        return this.growthRate * this.seasonalGrowthFactor(LevelContext.create((LevelAccessor)level), rootPos);
    }

    public int getUpProbability() {
        return this.upProbability;
    }

    public int getProbabilityForCurrentDir() {
        return 1;
    }

    public int getLowestBranchHeight() {
        return this.lowestBranchHeight;
    }

    public float getTapering() {
        return this.tapering;
    }

    public boolean doesRequireTileEntity(LevelAccessor level, BlockPos pos) {
        return !this.isCommonSpecies() && !this.shouldOverrideCommon((BlockGetter)level, pos);
    }

    public boolean isTransformable() {
        return this.transformable;
    }

    public Species setTransformable(boolean transformable) {
        this.transformable = transformable;
        return this;
    }

    public boolean hasCommonOverride() {
        return this.commonOverride != null;
    }

    public void setCommonOverride(CommonOverride commonOverride) {
        this.commonOverride = commonOverride;
    }

    public boolean shouldOverrideCommon(BlockGetter level, BlockPos trunkPos) {
        if (ServerLifecycleHooks.getCurrentServer() == null) {
            LogManager.getLogger().warn("shouldOverrideCommon was called before the server was loaded, will return false for now.");
            return false;
        }
        return this.hasCommonOverride() && this.commonOverride.test(level, trunkPos);
    }

    public Species setLeavesProperties(LeavesProperties leavesProperties) {
        this.leavesProperties = leavesProperties;
        leavesProperties.setFamily(this.getFamily());
        this.addValidLeafBlocks(leavesProperties);
        return this;
    }

    public LeavesProperties getLeavesProperties() {
        return this.leavesProperties;
    }

    public Optional<DynamicLeavesBlock> getLeavesBlock() {
        return this.leavesProperties.getDynamicLeavesBlock();
    }

    public Optional<Block> getPrimitiveLeaves() {
        return Optionals.ofBlock(this.leavesProperties.getPrimitiveLeaves().m_60734_());
    }

    public void addValidLeafBlocks(LeavesProperties ... leaves) {
        for (LeavesProperties leaf : leaves) {
            if (this.validLeaves.contains(leaf)) continue;
            this.validLeaves.add(leaf);
        }
    }

    public int getLeafBlockIndex(DynamicLeavesBlock block) {
        int index = this.validLeaves.indexOf(block.properties);
        if (index < 0) {
            LogManager.getLogger().warn("Block {} not valid leaves for {}.", (Object)block, (Object)this);
            return 0;
        }
        return index;
    }

    public LeavesProperties getValidLeavesProperties(int index) {
        if (index < this.validLeaves.size()) {
            return this.validLeaves.get(index);
        }
        LogManager.getLogger().warn("Attempted to get leaves properties of index {} but {} only has {} valid leaves.", (Object)index, (Object)this, (Object)this.validLeaves.size());
        return this.validLeaves.get(0);
    }

    public DynamicLeavesBlock getValidLeafBlock(int index) {
        LeavesProperties properties = this.getValidLeavesProperties(index);
        if (!properties.getDynamicLeavesBlock().isPresent()) {
            return null;
        }
        return (DynamicLeavesBlock)properties.getDynamicLeavesState().m_60734_();
    }

    public boolean isValidLeafBlock(DynamicLeavesBlock leavesBlock) {
        return this.validLeaves.stream().anyMatch(properties -> properties.getDynamicLeavesBlock().orElse(null) == leavesBlock);
    }

    public int colorTreeQuads(int defaultColor, FallingTreeEntityModel.TreeQuadData treeQuad) {
        return defaultColor;
    }

    public int leafColorMultiplier(Level level, BlockPos pos) {
        return this.getLeavesProperties().treeFallColorMultiplier(this.getLeavesProperties().getDynamicLeavesState(), (BlockAndTintGetter)level, pos);
    }

    public ItemStack getSeedStack(int qty) {
        return !this.hasSeed() ? ItemStack.f_41583_ : new ItemStack((ItemLike)this.seed.get(), qty);
    }

    public boolean hasSeed() {
        return this.seed != null;
    }

    public Optional<Seed> getSeed() {
        return Optional.ofNullable(this.seed == null ? null : this.seed.get());
    }

    public boolean shouldGenerateSeed() {
        return this.shouldGenerateSeed != null && this.shouldGenerateSeed != false;
    }

    public void setShouldGenerateSeed(boolean shouldGenerateSeed) {
        this.shouldGenerateSeed = shouldGenerateSeed;
    }

    public Species setShouldGenerateSeedIfNull(boolean shouldGenerateSeed) {
        if (this.shouldGenerateSeed == null) {
            this.shouldGenerateSeed = shouldGenerateSeed;
        }
        return this;
    }

    public ResourceLocation getSeedName() {
        if (this.seedName == null) {
            return ResourceLocationUtils.suffix(this.getRegistryName(), "_seed");
        }
        return new ResourceLocation(this.getRegistryName().m_135827_(), this.seedName);
    }

    public void setSeedName(String name) {
        this.seedName = name;
    }

    public Species generateSeed() {
        return !this.shouldGenerateSeed() || this.seed != null ? this : this.setSeed((Supplier<Seed>)RegistryHandler.addItem(this.getSeedName(), () -> new Seed(this)));
    }

    public Species setSeed(Supplier<Seed> seedSup) {
        this.seed = seedSup;
        return this;
    }

    public List<ItemStack> getVoluntaryDrops(Level level, BlockPos rootPos, int fertility) {
        if (level.f_46443_) {
            return Collections.emptyList();
        }
        return this.getLootTable(level.m_7654_().m_278653_(), species -> species.voluntaryDropsPath.get()).m_287195_(this.createVoluntaryLootParams(level, rootPos, fertility));
    }

    private LootParams createVoluntaryLootParams(Level level, BlockPos rootPos, int fertility) {
        return new LootParams.Builder(LevelContext.getServerLevelOrThrow((LevelAccessor)level)).m_287286_(LootContextParams.f_81461_, (Object)level.m_8055_(rootPos)).m_287286_(DTLootContextParams.SEASONAL_SEED_DROP_FACTOR, (Object)Float.valueOf(this.seasonalSeedDropFactor(LevelContext.create((LevelAccessor)level), rootPos))).m_287286_(DTLootContextParams.FERTILITY, (Object)fertility).m_287235_(DTLootParameterSets.VOLUNTARY);
    }

    public LootTable getLootTable(LootDataManager lootTables, Function<Species, ResourceLocation> nameFunction) {
        LootTable table = lootTables.m_278676_(nameFunction.apply(this));
        return table == LootTable.f_79105_ ? (this.isCommonSpecies() ? lootTables.m_278676_(nameFunction.apply(this.getCommonSpecies())) : LootTable.f_79105_) : table;
    }

    public List<ItemStack> getBranchesDrops(Level level, NetVolumeNode.Volume volume) {
        return this.getBranchesDrops(level, volume, ItemStack.f_41583_);
    }

    public List<ItemStack> getBranchesDrops(Level level, NetVolumeNode.Volume volume, ItemStack tool) {
        return this.getBranchesDrops(level, volume, tool, null);
    }

    public List<ItemStack> getBranchesDrops(Level level, NetVolumeNode.Volume volume, ItemStack tool, @Nullable Float explosionRadius) {
        this.processVolume(volume);
        if (level.f_46443_) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (int i = 0; i < this.family.getNumberOfValidBranchBlocks(); ++i) {
            int branchVolume = volume.getRawVolume(i);
            if (branchVolume <= 0) continue;
            BranchBlock branchBlock = this.family.getValidBranchBlock(i);
            drops.addAll(this.getDropsForBranchType(level, tool, explosionRadius, branchVolume, branchBlock));
        }
        this.cleanDropsList(drops);
        return drops;
    }

    public void processVolume(NetVolumeNode.Volume volume) {
        volume.multiplyVolume((Double)DTConfigs.TREE_HARVEST_MULTIPLIER.get());
        volume.multiplyVolume(this.getFamily().getLootVolumeMultiplier());
    }

    private List<ItemStack> getDropsForBranchType(Level level, ItemStack tool, @Nullable Float explosionRadius, int branchVolume, BranchBlock branchBlock) {
        return branchBlock.getLootTable(level.m_7654_().m_278653_(), this).m_287195_(this.createBranchesLootParams(level, branchVolume, tool, explosionRadius));
    }

    private LootParams createBranchesLootParams(Level level, int volume, ItemStack tool, @Nullable Float explosionRadius) {
        return new LootParams.Builder(LevelContext.getServerLevelOrThrow((LevelAccessor)level)).m_287286_(LootContextParams.f_81463_, (Object)tool).m_287286_(DTLootContextParams.SPECIES, (Object)this).m_287286_(DTLootContextParams.VOLUME, (Object)volume).m_287289_(LootContextParams.f_81464_, (Object)explosionRadius).m_287235_(DTLootParameterSets.BRANCHES);
    }

    private void cleanDropsList(List<ItemStack> drops) {
        for (int i = 0; i < drops.size(); ++i) {
            ItemStack drop = drops.get(i);
            if (drop.m_41720_() == Items.f_41852_) {
                drops.remove(i--);
            }
            if (drop.m_41613_() <= drop.m_41741_()) continue;
            ItemStack copiedStack = drop.m_41777_();
            copiedStack.m_41764_(drop.m_41613_() - drop.m_41741_());
            drops.add(copiedStack);
            drop.m_41764_(drop.m_41741_());
        }
    }

    public LogsAndSticks getLogsAndSticks(NetVolumeNode.Volume volume) {
        return this.getLogsAndSticks(volume, false, 0);
    }

    public LogsAndSticks getLogsAndSticks(NetVolumeNode.Volume volume, boolean silkTouch, int fortuneLevel) {
        LinkedList<ItemStack> logsList = new LinkedList<ItemStack>();
        int[] volArray = volume.getRawVolumesArray();
        float stickVol = 0.0f;
        for (int i = 0; i < volArray.length; ++i) {
            float vol = (float)volArray[i] / 4096.0f;
            if (!(vol > 0.0f)) continue;
            stickVol += this.getFamily().getValidBranchBlock(i).getPrimitiveLogs(vol, logsList);
        }
        int sticks = (int)(stickVol * 8.0f);
        return new LogsAndSticks(logsList, sticks);
    }

    public boolean handleVoluntaryDrops(Level level, List<BlockPos> endPoints, BlockPos rootPos, BlockPos treePos, int fertility) {
        int tickSpeed = level.m_46469_().m_46215_(GameRules.f_46143_);
        if (tickSpeed > 0) {
            List<ItemStack> drops;
            double slowFactor = 3.0 / (double)tickSpeed;
            if (level.f_46441_.m_188500_() < slowFactor && !(drops = this.getVoluntaryDrops(level, rootPos, fertility)).isEmpty() && !endPoints.isEmpty()) {
                for (ItemStack drop : drops) {
                    BlockPos branchPos = endPoints.get(level.f_46441_.m_188503_(endPoints.size()));
                    BlockPos itemPos = CoordUtils.getRayTraceFruitPos((LevelAccessor)level, this, treePos, branchPos = branchPos.m_7494_(), SafeChunkBounds.ANY);
                    if (itemPos == BlockPos.f_121853_) continue;
                    ItemEntity itemEntity = new ItemEntity(level, (double)itemPos.m_123341_() + 0.5, (double)itemPos.m_123342_() + 0.5, (double)itemPos.m_123343_() + 0.5, drop);
                    Vec3 motion = new Vec3((double)itemPos.m_123341_(), (double)itemPos.m_123342_(), (double)itemPos.m_123343_()).m_82546_(new Vec3((double)treePos.m_123341_(), (double)treePos.m_123342_(), (double)treePos.m_123343_()));
                    float distAngle = 15.0f;
                    float launchSpeed = 4.0f;
                    motion = new Vec3(motion.f_82479_, 0.0, motion.f_82480_).m_82541_().m_82524_(level.f_46441_.m_188501_() * distAngle * 2.0f - distAngle).m_82490_((double)(launchSpeed / 20.0f));
                    itemEntity.m_20334_(motion.f_82479_, motion.f_82480_, motion.f_82481_);
                    return level.m_7967_((Entity)itemEntity);
                }
            }
        }
        return true;
    }

    public void addPrimitiveSaplingRecipe(SeedSaplingRecipe recipe) {
        if (recipe.shouldReplaceSaplingWhenPlaced()) {
            recipe.getSaplingBlock().ifPresent(block -> TreeRegistry.registerSaplingReplacer(block.m_49966_(), this));
        }
        this.primitiveSaplingRecipe.add(recipe);
    }

    public Set<SeedSaplingRecipe> getPrimitiveSaplingRecipes() {
        return new HashSet<SeedSaplingRecipe>(this.primitiveSaplingRecipe);
    }

    public Species addPrimitiveSaplingItem(Item primitiveSaplingItem) {
        this.primitiveSaplingRecipe.add(new SeedSaplingRecipe(primitiveSaplingItem));
        return this;
    }

    public Species setSapling(Supplier<DynamicSaplingBlock> sapling) {
        this.saplingBlock = sapling;
        return this;
    }

    public boolean shouldGenerateSapling() {
        return this.shouldGenerateSapling != null && this.shouldGenerateSapling != false;
    }

    public void setShouldGenerateSapling(boolean shouldGenerateSapling) {
        this.shouldGenerateSapling = shouldGenerateSapling;
    }

    public Species setShouldGenerateSaplingIfNull(boolean shouldGenerateSapling) {
        if (this.shouldGenerateSapling == null) {
            this.shouldGenerateSapling = shouldGenerateSapling;
        }
        return this;
    }

    public Species generateSapling() {
        return !this.shouldGenerateSapling() || this.saplingBlock != null ? this : this.setSapling((Supplier<DynamicSaplingBlock>)RegistryHandler.addBlock(this.getSaplingRegName(), () -> new DynamicSaplingBlock(this)));
    }

    public Optional<DynamicSaplingBlock> getSapling() {
        return Optional.ofNullable(this.saplingBlock == null ? null : this.saplingBlock.get());
    }

    public Species selfOrLocationOverride(BlockGetter level, BlockPos pos) {
        return this.shouldUseLocationOverride() ? this.getFamily().getSpeciesForLocation(level, pos, this) : this;
    }

    public boolean shouldUseLocationOverride() {
        return !this.getSapling().isPresent() || this.isCommonSpecies();
    }

    public boolean plantSapling(LevelAccessor level, BlockPos pos, boolean locationOverride) {
        DynamicSaplingBlock sapling;
        DynamicSaplingBlock commonSapling = this.getCommonSpecies().getSapling().orElse(null);
        DynamicSaplingBlock dynamicSaplingBlock = sapling = locationOverride ? commonSapling : this.getSapling().orElse(commonSapling);
        if (sapling == null || !level.m_8055_(pos).m_247087_() || !DynamicSaplingBlock.canSaplingStay((LevelReader)level, this, pos)) {
            return false;
        }
        level.m_5594_(null, pos, this.saplingSound.m_56777_(), SoundSource.BLOCKS, 1.0f, 0.8f);
        level.m_7731_(pos, sapling.m_49966_(), 3);
        return true;
    }

    public void addAcceptableBlockForGrowth(Block block) {
        this.acceptableBlocksForGrowth.add(block);
    }

    public boolean canSaplingGrow(LevelReader level, BlockPos pos) {
        return this.acceptableBlocksForGrowth.isEmpty() || this.acceptableBlocksForGrowth.stream().anyMatch(block -> block == level.m_8055_(pos.m_7495_()).m_60734_());
    }

    public Species setCanSaplingGrowNaturally(boolean canSaplingGrowNaturally) {
        this.canSaplingGrowNaturally = canSaplingGrowNaturally;
        return this;
    }

    public boolean canSaplingGrowNaturally(Level level, BlockPos pos) {
        return this.canSaplingGrowNaturally && this.canSaplingGrow((LevelReader)level, pos);
    }

    public boolean canSaplingConsumeBoneMeal(LevelReader level, BlockPos pos) {
        return this.canBoneMealTree() && this.canSaplingGrow(level, pos);
    }

    public boolean canSaplingGrowAfterBoneMeal(Level level, RandomSource rand, BlockPos pos) {
        return this.canBoneMealTree() && this.canSaplingGrow((LevelReader)level, pos);
    }

    public int saplingFireSpread() {
        return 0;
    }

    public int saplingFlammability() {
        return 0;
    }

    public final boolean transitionToTree(Level level, BlockPos pos) {
        return !Hooks.onTransitionSaplingToTree(this, level, pos) && this.shouldTransitionToTree(level, pos) && this.transitionToTree(level, pos, this.getFamily());
    }

    protected boolean shouldTransitionToTree(Level level, BlockPos pos) {
        return level.m_46859_(pos.m_7494_()) && this.isAcceptableSoil((LevelReader)level, pos.m_7495_(), level.m_8055_(pos.m_7495_()));
    }

    protected boolean transitionToTree(Level level, BlockPos pos, Family family) {
        family.getBranch().ifPresent(branch -> branch.setRadius((LevelAccessor)level, pos, family.getPrimaryThickness(), null));
        level.m_46597_(pos.m_7494_(), this.getLeavesProperties().getDynamicLeavesState());
        this.placeRootyDirtBlock((LevelAccessor)level, pos.m_7495_(), 15);
        if (this.doesRequireTileEntity((LevelAccessor)level, pos)) {
            SpeciesBlockEntity speciesBlockEntity = (SpeciesBlockEntity)DTRegistries.SPECIES_BLOCK_ENTITY.m_155264_(pos.m_7495_(), level.m_8055_(pos.m_7495_()));
            level.m_151523_((BlockEntity)speciesBlockEntity);
            speciesBlockEntity.setSpecies(this);
        }
        return true;
    }

    public VoxelShape getSaplingShape() {
        return this.saplingShape;
    }

    public Species setSaplingShape(VoxelShape saplingShape) {
        this.saplingShape = saplingShape;
        return this;
    }

    public ResourceLocation getSaplingRegName() {
        if (this.saplingName == null) {
            return ResourceLocationUtils.suffix(this.getRegistryName(), "_sapling");
        }
        return new ResourceLocation(this.getRegistryName().m_135827_(), this.saplingName);
    }

    public String getSaplingModelName() {
        return "block/saplings/" + Objects.requireNonNullElseGet(this.saplingName, () -> this.getRegistryName().m_135815_());
    }

    public void setSaplingName(String name) {
        this.saplingName = name;
    }

    public void setTintSapling(Boolean tintSapling) {
        this.tintSapling = tintSapling;
    }

    public int saplingColorMultiplier(BlockState state, BlockAndTintGetter level, BlockPos pos, int tintIndex) {
        if (this.tintSapling.booleanValue()) {
            if (tintIndex == 0) {
                return this.getLeavesProperties().foliageColorMultiplier(state, level, pos);
            }
            if (tintIndex == 1) {
                return this.family.getRootColor(state, true);
            }
            return -1;
        }
        return -1;
    }

    public SoundType getSaplingSound() {
        return this.saplingSound;
    }

    public Species setSaplingSound(SoundType saplingSound) {
        this.saplingSound = saplingSound;
        return this;
    }

    public boolean placeRootyDirtBlock(LevelAccessor level, BlockPos rootPos, int fertility) {
        BlockState dirtState = level.m_8055_(rootPos);
        Block dirt = dirtState.m_60734_();
        if (!SoilHelper.isSoilRegistered(dirt) && !(dirt instanceof RootyBlock)) {
            LogManager.getLogger().warn("Rooty Dirt block NOT FOUND for soil " + ForgeRegistries.BLOCKS.getKey((Object)dirt));
            this.placeRootyDirtBlock(level, rootPos, Blocks.f_50493_.m_49966_(), fertility);
            return false;
        }
        if (dirt instanceof RootyBlock) {
            this.updateRootyDirtBlock(level, rootPos, dirtState, fertility);
        } else if (SoilHelper.isSoilRegistered(dirt)) {
            this.placeRootyDirtBlock(level, rootPos, dirtState, fertility);
        }
        BlockEntity tileEntity = level.getExistingBlockEntity(rootPos);
        if (tileEntity instanceof SpeciesBlockEntity) {
            SpeciesBlockEntity speciesTE = (SpeciesBlockEntity)tileEntity;
            speciesTE.setSpecies(this);
        }
        return true;
    }

    private void placeRootyDirtBlock(LevelAccessor level, BlockPos rootPos, BlockState primitiveDirtState, int fertility) {
        SoilProperties soilProperties = this.forceSoil != null ? this.forceSoil : SoilHelper.getProperties(primitiveDirtState.m_60734_());
        soilProperties.getBlock().ifPresent(block -> level.m_7731_(rootPos, soilProperties.getSoilState(primitiveDirtState, fertility, this.doesRequireTileEntity(level, rootPos)), 3));
    }

    private void updateRootyDirtBlock(LevelAccessor level, BlockPos rootPos, BlockState soilState, int fertility) {
        if (soilState.m_60734_() instanceof RootyBlock) {
            level.m_7731_(rootPos, (BlockState)((BlockState)soilState.m_61124_((Property)RootyBlock.FERTILITY, (Comparable)Integer.valueOf(fertility))).m_61124_((Property)RootyBlock.IS_VARIANT, (Comparable)Boolean.valueOf(this.doesRequireTileEntity(level, rootPos))), 3);
        }
    }

    public SoilProperties getForceSoil() {
        return this.forceSoil;
    }

    public Species setForceSoil(SoilProperties soil) {
        this.forceSoil = soil;
        return this;
    }

    public Species setSoilLongevity(int longevity) {
        this.soilLongevity = longevity;
        return this;
    }

    public int getSoilLongevity(Level level, BlockPos rootPos) {
        return (int)(this.biomeSuitability(level, rootPos) * (float)this.soilLongevity);
    }

    public boolean isThick() {
        return this.maxBranchRadius > 8;
    }

    public int getMaxBranchRadius() {
        return this.maxBranchRadius;
    }

    public void setMaxBranchRadius(int maxBranchRadius) {
        this.maxBranchRadius = Mth.m_14045_((int)maxBranchRadius, (int)1, (int)this.getFamily().getMaxBranchRadius());
    }

    public Species addAcceptableSoils(String ... soilTypes) {
        this.soilTypeFlags |= SoilHelper.getSoilFlags(soilTypes);
        return this;
    }

    public Species addAcceptableSoilsForWorldGen(String ... soilTypes) {
        this.worldGenSoilTypeFlags |= SoilHelper.getSoilFlags(soilTypes);
        return this;
    }

    public Species clearAcceptableSoils() {
        this.soilTypeFlags = 0;
        this.worldGenSoilTypeFlags = 0;
        return this;
    }

    protected void setStandardSoils() {
        this.addAcceptableSoils("dirt_like");
    }

    public boolean hasAcceptableSoil() {
        return this.soilTypeFlags != 0;
    }

    public boolean isAcceptableSoil(BlockState soilBlockState) {
        return SoilHelper.isSoilAcceptable(soilBlockState, this.soilTypeFlags);
    }

    public boolean isAcceptableSoil(String ... soilTypes) {
        return (SoilHelper.getSoilFlags(soilTypes) & this.soilTypeFlags) != 0;
    }

    public boolean isAcceptableSoil(LevelReader level, BlockPos pos, BlockState soilBlockState) {
        return this.isAcceptableSoil(soilBlockState);
    }

    public void setAllowedWaterHeightForWorldgen(int allowedWaterHeightForWorldgen) {
        this.allowedWaterHeightForWorldgen = allowedWaterHeightForWorldgen;
    }

    public int getAllowedWaterHeightForWorldgen() {
        return this.allowedWaterHeightForWorldgen;
    }

    public boolean isAcceptableSoilForWorldgen(LevelAccessor level, BlockPos pos, BlockState soilBlockState) {
        boolean isAcceptableSoil = this.isAcceptableSoilForWorldgen(soilBlockState);
        if (isAcceptableSoil && this.isWater(soilBlockState)) {
            int maxH = this.getAllowedWaterHeightForWorldgen();
            int waterBelow = this.countWaterBlocksBelow(level, pos, maxH + 2);
            return waterBelow <= maxH && this.isAcceptableSoilForWorldgen(level.m_8055_(pos.m_6625_(waterBelow)));
        }
        return isAcceptableSoil;
    }

    public boolean isAcceptableSoilForWorldgen(BlockState soilBlockState) {
        return SoilHelper.isSoilAcceptable(soilBlockState, this.soilTypeFlags) || SoilHelper.isSoilAcceptable(soilBlockState, this.worldGenSoilTypeFlags);
    }

    protected boolean isWater(BlockState soilBlockState) {
        return SoilHelper.isSoilAcceptable(soilBlockState, SoilHelper.getSoilFlags("water_like"));
    }

    protected int countWaterBlocksBelow(LevelAccessor level, BlockPos startPos, int maxCount) {
        BlockState downState;
        int i;
        for (i = 0; i <= maxCount && this.isWater(downState = level.m_8055_(startPos.m_6625_(i))); ++i) {
        }
        return i;
    }

    public void setPlantableOnFluid(boolean plantableOnFluid) {
        this.plantableOnFluid = plantableOnFluid;
    }

    public boolean isPlantableOnFluid() {
        return this.plantableOnFluid;
    }

    public boolean soilDestroyAction(Level level, @Nonnull BlockPos rootPos, BlockState state, @Nonnull Player player) {
        return false;
    }

    public boolean update(Level level, RootyBlock rootyDirt, BlockPos rootPos, int fertility, TreePart treeBase, BlockPos treePos, RandomSource random, boolean natural) {
        List<BlockPos> ends = this.getEnds(level, treePos, treeBase);
        if (this.handleRot((LevelAccessor)level, ends, rootPos, treePos, fertility, SafeChunkBounds.ANY)) {
            return false;
        }
        if (natural) {
            this.handleVoluntaryDrops(level, ends, rootPos, treePos, fertility);
            if (this.handleDisease(level, treeBase, treePos, random, fertility)) {
                return true;
            }
        }
        return this.grow(level, rootyDirt, rootPos, fertility, treeBase, treePos, random, natural);
    }

    protected final List<BlockPos> getEnds(Level level, BlockPos treePos, TreePart treeBase) {
        FindEndsNode endFinder = new FindEndsNode();
        treeBase.analyse(level.m_8055_(treePos), (LevelAccessor)level, treePos, null, new MapSignal(endFinder));
        return endFinder.getEnds();
    }

    public boolean handleRot(LevelAccessor level, List<BlockPos> ends, BlockPos rootPos, BlockPos treePos, int fertility, SafeChunkBounds safeBounds) {
        Iterator<BlockPos> iter = ends.iterator();
        SimpleVoxmap leafMap = this.getLeavesProperties().getCellKit().getLeafCluster();
        while (iter.hasNext()) {
            BlockPos endPos = iter.next();
            BlockState branchState = level.m_8055_(endPos);
            BranchBlock branch = TreeHelper.getBranch(branchState);
            if (branch == null) continue;
            int radius = branch.getRadius(branchState);
            float rotChance = this.rotChance(level, endPos, level.m_213780_(), radius);
            if (!branch.checkForRot(level, endPos, this, fertility, radius, level.m_213780_(), rotChance, safeBounds != SafeChunkBounds.ANY) && radius == this.family.getPrimaryThickness()) continue;
            if (safeBounds != SafeChunkBounds.ANY) {
                TreeHelper.ageVolume(level, endPos.m_6625_((leafMap.getLenZ() - 1) / 2), (leafMap.getLenX() - 1) / 2, leafMap.getLenY(), 2, safeBounds);
            }
            iter.remove();
        }
        return ends.isEmpty() && !TreeHelper.isBranch(level.m_8055_(treePos));
    }

    public void setDoesRot(boolean doesRot) {
        this.doesRot = doesRot;
    }

    public boolean rot(LevelAccessor level, BlockPos pos, int neighborCount, int radius, int fertility, RandomSource random, boolean rapid, boolean growLeaves) {
        if (!this.doesRot) {
            return false;
        }
        if (radius <= this.family.getPrimaryThickness()) {
            if (!this.getLeavesProperties().getDynamicLeavesBlock().isPresent()) {
                return false;
            }
            if (growLeaves) {
                DynamicLeavesBlock leaves = (DynamicLeavesBlock)this.getLeavesProperties().getDynamicLeavesState().m_60734_();
                for (Direction dir : upFirst) {
                    if (!leaves.growLeavesIfLocationIsSuitable(level, this.getLeavesProperties(), pos.m_121945_(dir), 0)) continue;
                    return false;
                }
            }
        }
        if (rapid || (Integer)DTConfigs.MAX_BRANCH_ROT_RADIUS.get() != 0 && radius <= (Integer)DTConfigs.MAX_BRANCH_ROT_RADIUS.get()) {
            BranchBlock branch = TreeHelper.getBranch(level.m_8055_(pos));
            if (branch != null) {
                branch.rot(level, pos);
            }
            this.postRot(new PostRotContext(level, pos, this, radius, neighborCount, fertility, rapid));
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean rot(LevelAccessor level, BlockPos pos, int neighborCount, int radius, RandomSource random, boolean rapid) {
        return false;
    }

    public void postRot(PostRotContext context) {
        this.genFeatures.forEach(configuration -> configuration.generate(GenFeature.Type.POST_ROT, context));
    }

    public float rotChance(LevelAccessor level, BlockPos pos, RandomSource rand, int radius) {
        if (radius == 0) {
            return 0.0f;
        }
        return 0.3f + 1.0f / (float)radius;
    }

    public boolean grow(Level level, RootyBlock rootyDirt, BlockPos rootPos, int fertility, TreePart treeBase, BlockPos treePos, RandomSource random, boolean natural) {
        float growthRate = (float)((double)this.getGrowthRate(level, rootPos) * (Double)DTConfigs.TREE_GROWTH_MULTIPLIER.get() * (double)((Integer)DTConfigs.TREE_GROWTH_FOLDING.get()).intValue());
        do {
            if (fertility <= 0 || !(growthRate > random.m_188501_())) continue;
            GrowSignal signal = this.sendGrowthSignal(treeBase, level, treePos, rootPos, rootyDirt.getTrunkDirection((BlockGetter)level, rootPos));
            int soilLongevity = this.getSoilLongevity(level, rootPos) * (signal.success ? 1 : 16);
            if (soilLongevity <= 0 || random.m_188503_(soilLongevity) == 0) {
                rootyDirt.setFertility(level, rootPos, fertility - 1);
            }
            if (!signal.choked) continue;
            fertility = 0;
            rootyDirt.setFertility(level, rootPos, fertility);
            TreeHelper.startAnalysisFromRoot((LevelAccessor)level, rootPos, new MapSignal(new ShrinkerNode(signal.getSpecies())));
        } while ((growthRate -= 1.0f) > 0.0f);
        this.postGrow(level, rootPos, treePos, fertility, natural);
        return true;
    }

    protected GrowSignal sendGrowthSignal(TreePart treeBase, Level level, BlockPos treePos, BlockPos rootPos, Direction defaultDir) {
        GrowSignal signal = new GrowSignal(this, rootPos, this.getEnergy(level, rootPos), level.f_46441_, defaultDir);
        return treeBase.growSignal(level, treePos, signal);
    }

    public Species setGrowthLogicKit(GrowthLogicKit logicKit) {
        this.logicKit = (GrowthLogicKitConfiguration)logicKit.getDefaultConfiguration();
        return this;
    }

    public Species setGrowthLogicKit(GrowthLogicKitConfiguration logicKit) {
        this.logicKit = logicKit;
        return this;
    }

    public GrowthLogicKitConfiguration getGrowthLogicKit() {
        return this.logicKit;
    }

    public void setCanBoneMealTree(boolean canBoneMealTree) {
        this.canBoneMealTree = canBoneMealTree;
    }

    public boolean canBoneMealTree() {
        return this.canBoneMealTree;
    }

    public boolean postGrow(Level level, BlockPos rootPos, BlockPos treePos, int fertility, boolean natural) {
        this.genFeatures.forEach(configuration -> configuration.generate(GenFeature.Type.POST_GROW, new PostGrowContext(level, rootPos, this, treePos, fertility, natural)));
        return true;
    }

    public boolean handleDisease(Level level, TreePart baseTreePart, BlockPos treePos, RandomSource random, int fertility) {
        if (fertility == 0 && (Double)DTConfigs.DISEASE_CHANCE.get() > (double)random.m_188501_()) {
            baseTreePart.analyse(level.m_8055_(treePos), (LevelAccessor)level, treePos, Direction.DOWN, new MapSignal(new DiseaseNode(this)));
            return true;
        }
        return false;
    }

    public Species envFactor(TagKey<Biome> type, float factor) {
        this.envFactors.put(type, Float.valueOf(factor));
        return this;
    }

    public float biomeSuitability(Level level, BlockPos pos) {
        Holder biomeHolder = level.m_204166_(pos);
        Biome biome = (Biome)biomeHolder.m_203334_();
        BiomeSuitabilityEvent suitabilityEvent = new BiomeSuitabilityEvent(level, biome, this, pos);
        MinecraftForge.EVENT_BUS.post((Event)suitabilityEvent);
        if (suitabilityEvent.isHandled()) {
            return suitabilityEvent.getSuitability();
        }
        float ugs = (float)((Double)DTConfigs.SCALE_BIOME_GROWTH_RATE.get()).doubleValue();
        if (ugs == 1.0f || this.isBiomePerfect((Holder<Biome>)biomeHolder)) {
            return 1.0f;
        }
        float suit = Species.defaultSuitability();
        for (TagKey t : biomeHolder.m_203616_().toList()) {
            suit *= this.envFactors.getOrDefault(t, Float.valueOf(1.0f)).floatValue();
        }
        suit = ugs <= 0.5f ? ugs * 2.0f * suit : ((1.0f - ugs) * suit + (ugs - 0.5f)) * 2.0f;
        return Mth.m_14036_((float)suit, (float)0.0f, (float)1.0f);
    }

    public boolean isBiomePerfect(Holder<Biome> biome) {
        return this.perfectBiomes.m_203333_(biome);
    }

    public boolean isBiomePerfect(ResourceKey<Biome> biome) {
        return false;
    }

    public DTBiomeHolderSet getPerfectBiomes() {
        return this.perfectBiomes;
    }

    public static float defaultSuitability() {
        return 0.85f;
    }

    @SafeVarargs
    public static boolean isOneOfBiomes(ResourceKey<Biome> biomeToCheck, ResourceKey<Biome> ... biomes) {
        for (ResourceKey<Biome> biome : biomes) {
            if (!biomeToCheck.equals(biome)) continue;
            return true;
        }
        return false;
    }

    public void setSeasonalGrowthOffset(@Nullable Float offset) {
        this.seasonalGrowthOffset = offset;
    }

    public void setSeasonalSeedDropOffset(@Nullable Float offset) {
        this.seasonalSeedDropOffset = offset;
    }

    public void setSeasonalFruitingOffset(@Nullable Float offset) {
        this.seasonalFruitingOffset = offset;
    }

    public float seasonalGrowthFactor(LevelContext levelContext, BlockPos rootPos) {
        return this.seasonalGrowthOffset != null ? SeasonHelper.globalSeasonalGrowthFactor(levelContext, rootPos, -this.seasonalGrowthOffset.floatValue()) : 1.0f;
    }

    public float seasonalSeedDropFactor(LevelContext levelContext, BlockPos pos) {
        return this.seasonalSeedDropOffset != null ? SeasonHelper.globalSeasonalSeedDropFactor(levelContext, pos, -this.seasonalSeedDropOffset.floatValue()) : 1.0f;
    }

    public float seasonalFruitProductionFactor(LevelContext levelContext, BlockPos pos) {
        return this.seasonalFruitingOffset != null ? SeasonHelper.globalSeasonalFruitProductionFactor(levelContext, pos, -this.seasonalFruitingOffset.floatValue(), false) : 1.0f;
    }

    public void inheritSeasonalFruitingOffsetToFruits() {
        this.fruits.forEach(fruit -> fruit.setSeasonOffset(this.seasonalFruitingOffset));
    }

    public void inheritSeasonalFruitingOffsetToPods() {
        this.pods.forEach(pod -> pod.setSeasonOffset(this.seasonalFruitingOffset));
    }

    public int getSeasonalTooltipFlags(LevelContext levelContext) {
        float seasonStart = 0.16666667f;
        float seasonEnd = 0.8333333f;
        float threshold = 0.75f;
        if (this.hasFruits() || this.hasPods()) {
            int seasonFlags = 0;
            for (int i = 0; i < 4; ++i) {
                boolean isValidSeason = false;
                if (this.seasonalFruitingOffset != null) {
                    float prod2;
                    float prod1 = SeasonHelper.globalSeasonalFruitProductionFactor(levelContext, new BlockPos(0, (int)(((float)i + 0.16666667f - this.seasonalFruitingOffset.floatValue()) * 64.0f), 0), true);
                    if (Math.min(prod1, prod2 = SeasonHelper.globalSeasonalFruitProductionFactor(levelContext, new BlockPos(0, (int)(((float)i + 0.8333333f - this.seasonalFruitingOffset.floatValue()) * 64.0f), 0), true)) > 0.75f) {
                        isValidSeason = true;
                    }
                } else {
                    isValidSeason = true;
                }
                if (!isValidSeason) continue;
                seasonFlags |= 1 << i;
            }
            return seasonFlags;
        }
        return 0;
    }

    public Species setFlowerSeasonHold(float min, float max) {
        this.flowerSeasonHoldMin = min;
        this.flowerSeasonHoldMax = max;
        return this;
    }

    public boolean testFlowerSeasonHold(Float seasonValue) {
        if (this.seasonalFruitingOffset == null) {
            return false;
        }
        return SeasonHelper.isSeasonBetween(seasonValue, this.flowerSeasonHoldMin + this.seasonalFruitingOffset.floatValue(), this.flowerSeasonHoldMax + this.seasonalFruitingOffset.floatValue());
    }

    @Nullable
    public SubstanceEffect getSubstanceEffect(ItemStack itemStack) {
        if (this.canBoneMealTree() && itemStack.m_204117_(DTItemTags.FERTILIZER)) {
            return new FertilizeSubstance().setAmount(2).setGrow(true).setPulses(() -> ((ForgeConfigSpec.IntValue)DTConfigs.BONE_MEAL_GROWTH_PULSES).get());
        }
        if (itemStack.m_41720_() instanceof SubstanceEffectProvider) {
            SubstanceEffectProvider provider = (SubstanceEffectProvider)itemStack.m_41720_();
            return provider.getSubstanceEffect(itemStack);
        }
        if (itemStack.m_204117_(DTItemTags.ENHANCED_FERTILIZER)) {
            return new GrowthSubstance();
        }
        return null;
    }

    public boolean applySubstance(Level level, BlockPos rootPos, BlockPos hitPos, Player player, InteractionHand hand, ItemStack itemStack) {
        SubstanceEffect effect = this.getSubstanceEffect(itemStack);
        if (effect != null) {
            boolean applied = effect.apply(level, rootPos);
            if (applied && effect.isLingering()) {
                level.m_7967_((Entity)new LingeringEffectorEntity(level, rootPos, effect));
                return true;
            }
            return applied;
        }
        return false;
    }

    public boolean onTreeActivated(Family.TreeActivationContext context) {
        if (context.heldItem != null && this.applySubstance(context.level, context.rootPos, context.hitPos, context.player, context.hand, context.heldItem)) {
            Species.consumePlayerItem(context.player, context.hand, context.heldItem);
            return true;
        }
        return false;
    }

    public static void consumePlayerItem(Player player, InteractionHand hand, ItemStack heldItem) {
        if (!player.m_7500_()) {
            if (heldItem.m_41720_() instanceof Emptiable) {
                Emptiable emptiable = (Emptiable)heldItem.m_41720_();
                player.m_21008_(hand, emptiable.getEmptyContainer());
            } else if (heldItem.m_41720_() == Items.f_42589_) {
                player.m_21008_(hand, new ItemStack((ItemLike)Items.f_42590_));
            } else {
                heldItem.m_41774_(1);
            }
        }
    }

    public boolean useDefaultWailaBody() {
        return true;
    }

    public Species setAlwaysShowOnWaila(boolean alwaysShowOnWaila) {
        this.alwaysShowOnWaila = alwaysShowOnWaila;
        return this;
    }

    public boolean showSpeciesOnWaila() {
        if (this.alwaysShowOnWaila == null) {
            return this != this.getFamily().getCommonSpecies();
        }
        return this.alwaysShowOnWaila;
    }

    public Species getMegaSpecies() {
        return this.megaSpecies;
    }

    public Species getPreMegaSpecies() {
        return this.preMegaSpecies;
    }

    public boolean isMegaSpecies() {
        return this.preMegaSpecies.isValid();
    }

    public void setMegaSpecies(Species megaSpecies) {
        this.megaSpecies = megaSpecies;
        megaSpecies.preMegaSpecies = this;
    }

    public AnimationHandler selectAnimationHandler(FallingTreeEntity fallingEntity) {
        return this.getFamily().selectAnimationHandler(fallingEntity);
    }

    @Nullable
    public HashMap<BlockPos, BlockState> getFellingLeavesClusters(BranchDestructionData destructionData) {
        return null;
    }

    public boolean canEncodeLeavesBlocks(BlockPos pos, BlockState state, Block block, BranchDestructionData data) {
        return block instanceof DynamicLeavesBlock;
    }

    public int encodeLeavesPos(BlockPos pos, BlockState state, Block block, BranchDestructionData data) {
        return (Integer)state.m_61143_((Property)DynamicLeavesBlock.f_54418_) << 24 | BranchDestructionData.encodeRelBlockPos(pos);
    }

    public int encodeLeavesBlocks(BlockPos pos, BlockState state, Block block, BranchDestructionData data) {
        return this.getLeafBlockIndex((DynamicLeavesBlock)block);
    }

    public boolean leavesAreSolid() {
        return this.getLeavesProperties().getPrimitiveLeaves().m_280296_();
    }

    public SoundEvent getFallingTreeStartSound(float treeVolume, boolean hasLeaves) {
        return treeVolume > this.bigTreeSoundThreshold ? (SoundEvent)DTRegistries.FALLING_TREE_BIG_START.get() : (SoundEvent)DTRegistries.FALLING_TREE_MEDIUM_START.get();
    }

    public SoundEvent getFallingTreeEndSound(float treeVolume, boolean hasLeaves) {
        return treeVolume > this.bigTreeSoundThreshold ? (SoundEvent)DTRegistries.FALLING_TREE_BIG_END.get() : (SoundEvent)DTRegistries.FALLING_TREE_MEDIUM_END.get();
    }

    public float getFallingTreePitch(float treeVolume) {
        return treeVolume > this.bigTreeSoundThreshold ? 25.0f / treeVolume : 10.0f / (5.0f + treeVolume * 0.6f);
    }

    public float getFallingBranchPitch(float treeVolume) {
        return 1.0f / treeVolume;
    }

    public SoundEvent getFallingTreeHitWaterSound(float treeVolume, boolean hasLeaves) {
        return (SoundEvent)DTRegistries.FALLING_TREE_HIT_WATER.get();
    }

    public SoundEvent getFallingBranchEndSound(float treeVolume, boolean hasLeaves, boolean fellOnWater) {
        return fellOnWater ? (hasLeaves ? (SoundEvent)DTRegistries.FALLING_TREE_SMALL_HIT_WATER.get() : SoundEvents.f_12277_) : (hasLeaves ? (SoundEvent)DTRegistries.FALLING_TREE_SMALL_END.get() : (SoundEvent)DTRegistries.FALLING_TREE_SMALL_END_BARE.get());
    }

    public void setBigTreeSoundThreshold(float bigTreeSoundThreshold) {
        this.bigTreeSoundThreshold = bigTreeSoundThreshold;
    }

    public PottedSaplingBlock getPottedSapling() {
        return DTRegistries.POTTED_SAPLING.get();
    }

    public boolean generate(GenerationContext context) {
        JoCode code;
        AtomicBoolean fullGen = new AtomicBoolean(false);
        FullGenerationContext fullGenContext = new FullGenerationContext(context.level(), (BlockPos)context.rootPos(), this, context.biome(), context.radius(), context.safeBounds());
        this.genFeatures.forEach(configuration -> fullGen.set(fullGen.get() || configuration.generate(GenFeature.Type.FULL, fullGenContext) != false));
        if (fullGen.get()) {
            return true;
        }
        if (!this.shouldGenerate(context.levelContext(), (BlockPos)context.rootPos())) {
            return false;
        }
        if (!JoCodeRegistry.getCodes(this.getRegistryName()).isEmpty() && (code = JoCodeRegistry.getRandomCode(this.getRegistryName(), context.radius(), context.random())) != null) {
            code.generate(context);
            return true;
        }
        return false;
    }

    private boolean shouldGenerate(LevelContext levelContext, BlockPos rootPos) {
        BlockPos.MutableBlockPos pos = rootPos.m_7494_().m_122032_();
        int i = 0;
        while ((float)i < this.signalEnergy) {
            if (!DynamicTreeFeature.validTreePos((LevelSimulatedReader)levelContext.accessor(), (BlockPos)pos)) {
                return false;
            }
            pos.m_122173_(Direction.UP);
            ++i;
        }
        return true;
    }

    public JoCode getJoCode(String joCodeString) {
        return new JoCode(joCodeString);
    }

    public RootsJoCode getRootsJoCode(String joCodeString) {
        return new RootsJoCode(joCodeString);
    }

    public Collection<JoCode> getJoCodes() {
        return JoCodeRegistry.getCodes(this.getRegistryName()).values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Species addGenFeature(GenFeature feature) {
        return this.addGenFeature((GenFeatureConfiguration)feature.getDefaultConfiguration());
    }

    public Species addGenFeature(GenFeatureConfiguration configuration) {
        if (configuration.shouldApply(this)) {
            this.genFeatures.add(configuration);
        }
        return this;
    }

    public boolean hasGenFeatures() {
        return this.genFeatures.size() > 0;
    }

    public List<GenFeatureConfiguration> getGenFeatures() {
        return this.genFeatures;
    }

    public BlockPos preGeneration(LevelAccessor level, BlockPos.MutableBlockPos rootPos, int radius, Direction facing, SafeChunkBounds safeBounds, JoCode joCode) {
        this.genFeatures.forEach(configuration -> rootPos.m_122190_((Vec3i)configuration.generate(GenFeature.Type.PRE_GENERATION, new PreGenerationContext(level, (BlockPos)rootPos, this, radius, facing, safeBounds, joCode))));
        return rootPos.m_7949_();
    }

    public void postGeneration(PostGenerationContext context) {
        this.genFeatures.forEach(configuration -> configuration.generate(GenFeature.Type.POST_GENERATION, context));
    }

    public float getWorldGenTaperingFactor() {
        return 1.5f;
    }

    public int getWorldGenLeafMapHeight() {
        return this.worldGenLeafMapHeight;
    }

    public void setWorldGenLeafMapHeight(int worldGenLeafMapHeight) {
        this.worldGenLeafMapHeight = worldGenLeafMapHeight;
    }

    public int getWorldGenAgeIterations() {
        return 3;
    }

    public NodeInspector getNodeInflator(SimpleVoxmap leafMap) {
        return this.getNodeInflator(leafMap, this.getMaxBranchRadius());
    }

    public NodeInspector getNodeInflator(SimpleVoxmap leafMap, int maxRadius) {
        return new InflatorNode(this, leafMap, maxRadius);
    }

    public int coordHashCode(BlockPos pos) {
        return CoordUtils.coordHashCode(pos, 2);
    }

    public boolean hasFruit(Fruit fruit) {
        return this.fruits.contains(fruit);
    }

    public boolean hasFruits() {
        return !this.fruits.isEmpty();
    }

    public void addFruits(Collection<Fruit> fruits) {
        this.fruits.addAll(fruits);
    }

    public Set<Fruit> getFruits() {
        return Collections.unmodifiableSet(this.fruits);
    }

    public boolean hasPod(Pod pod) {
        return this.pods.contains(pod);
    }

    public boolean hasPods() {
        return !this.pods.isEmpty();
    }

    public void addPods(Collection<Pod> pods) {
        this.pods.addAll(pods);
    }

    public Set<Pod> getPods() {
        return Collections.unmodifiableSet(this.pods);
    }

    public List<TagKey<Block>> defaultSaplingTags() {
        return Collections.singletonList(DTBlockTags.SAPLINGS);
    }

    public List<TagKey<Item>> defaultSeedTags() {
        return Collections.singletonList(DTItemTags.SEEDS);
    }

    public void setOnlyIfLoaded(String onlyIfLoaded) {
        this.onlyIfLoaded.add(onlyIfLoaded);
    }

    public boolean isOnlyIfLoaded() {
        return !this.onlyIfLoaded.isEmpty();
    }

    public void setModelOverrides(Map<String, ResourceLocation> modelOverrides) {
        this.modelOverrides.putAll(modelOverrides);
    }

    public void setTextureOverrides(Map<String, ResourceLocation> textureOverrides) {
        this.textureOverrides.putAll(textureOverrides);
    }

    public void setLangOverrides(Map<String, String> textureOverrides) {
        this.langOverrides.putAll(textureOverrides);
    }

    public Optional<ResourceLocation> getModelPath(String key) {
        return Optional.ofNullable(this.modelOverrides.getOrDefault(key, null));
    }

    public Optional<ResourceLocation> getTexturePath(String key) {
        return Optional.ofNullable(this.textureOverrides.getOrDefault(key, null));
    }

    public Optional<String> getLangOverride(String key) {
        return Optional.ofNullable(this.langOverrides.getOrDefault(key, null));
    }

    public ResourceLocation getSaplingSmartModelLocation() {
        if (this.modelOverrides.containsKey(SAPLING)) {
            return this.modelOverrides.get(SAPLING);
        }
        return DynamicTrees.location("block/smartmodel/sapling");
    }

    public void addSaplingTextures(BiConsumer<String, ResourceLocation> textureConsumer, ResourceLocation leavesTextureLocation, ResourceLocation barkTextureLocation) {
        ResourceLocation leavesLoc = this.getLeavesProperties().getTexturePath("leaves").orElse(leavesTextureLocation);
        ResourceLocation logLoc = this.getFamily().getTexturePath("branch").orElse(barkTextureLocation);
        textureConsumer.accept("log", logLoc);
        textureConsumer.accept("leaves", leavesLoc);
    }

    @Override
    public void generateStateData(DTBlockStateProvider provider) {
        this.saplingStateGenerator.get().generate(provider, this);
    }

    public ResourceLocation getSeedParentModelLocation() {
        if (this.modelOverrides.containsKey(SEED_PARENT)) {
            return this.modelOverrides.get(SEED_PARENT);
        }
        return DynamicTrees.location("item/standard_seed");
    }

    public Generator<DTItemModelProvider, Species> getSeedModelGenerator() {
        return this.seedModelGenerator.get();
    }

    @Override
    public void generateItemModelData(DTItemModelProvider provider) {
        this.seedModelGenerator.get().generate(provider, this);
    }

    @Override
    public void generateLangData(DTLangProvider provider) {
        this.speciesLangProvider.get().generate(provider, this);
    }

    public boolean shouldGenerateVoluntaryDrops() {
        return this.seed != null;
    }

    public ResourceLocation getVoluntaryDropsPath() {
        return this.voluntaryDropsPath.get();
    }

    public LootTable.Builder createVoluntaryDrops() {
        return DTLootTableProvider.BlockLoot.createVoluntaryDrops(this.seed.get());
    }

    public void setDropSeeds(boolean dropSeeds) {
        this.dropSeeds = dropSeeds;
    }

    public boolean shouldDropSeeds() {
        return Optional.ofNullable(this.dropSeeds).orElse(!this.hasFruits());
    }

    @Override
    public String toLoadDataString() {
        RegistryHandler registryHandler = RegistryHandler.get(this.getRegistryName().m_135827_());
        return this.getString(Pair.of((Object)SEED, this.seed != null ? ForgeRegistries.ITEMS.getKey((Object)this.seed.get()) : null), Pair.of((Object)SAPLING, this.saplingBlock != null ? "Block{" + ForgeRegistries.BLOCKS.getKey((Object)this.saplingBlock.get()) + "}" : null));
    }

    @Override
    public String toReloadDataString() {
        return this.getString(Pair.of((Object)"tapering", (Object)Float.valueOf(this.tapering)), Pair.of((Object)"upProbability", (Object)this.upProbability), Pair.of((Object)"lowestBranchHeight", (Object)this.lowestBranchHeight), Pair.of((Object)"signalEnergy", (Object)Float.valueOf(this.signalEnergy)), Pair.of((Object)"growthRate", (Object)Float.valueOf(this.growthRate)), Pair.of((Object)"soilLongevity", (Object)this.soilLongevity), Pair.of((Object)"soilTypeFlags", (Object)this.soilTypeFlags), Pair.of((Object)"maxBranchRadius", (Object)this.maxBranchRadius), Pair.of((Object)"transformable", (Object)this.transformable), Pair.of((Object)"logicKit", (Object)this.logicKit), Pair.of((Object)"leavesProperties", (Object)this.leavesProperties), Pair.of((Object)"envFactors", this.envFactors), Pair.of((Object)"megaSpecies", (Object)this.megaSpecies), Pair.of((Object)SEED, this.seed), Pair.of((Object)"primitive_sapling", (Object)TreeRegistry.SAPLING_REPLACERS.entrySet().stream().filter(entry -> entry.getValue() == this).map(Map.Entry::getKey).findAny().orElse(Blocks.f_50016_)), Pair.of((Object)"perfectBiomes", (Object)((Object)this.perfectBiomes)), Pair.of((Object)"acceptableBlocksForGrowth", this.acceptableBlocksForGrowth), Pair.of((Object)"genFeatures", this.genFeatures));
    }

    public void addGeneratedBlockTags(Function<TagKey<Block>, IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block>> tagAppender) {
        this.getSapling().ifPresent(sapling -> this.defaultSaplingTags().forEach(tag -> {
            if (!this.isOnlyIfLoaded()) {
                ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)tagAppender.apply((TagKey<Block>)tag)).m_255245_((Object)sapling);
            } else {
                ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)tagAppender.apply((TagKey<Block>)tag)).m_176839_(BuiltInRegistries.f_256975_.m_7981_((Object)sapling));
            }
        }));
    }

    public void addGeneratedItemTags(Function<TagKey<Item>, IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>> tagAppender) {
        if (!this.hasSeed()) {
            return;
        }
        this.getSeed().ifPresent(seed -> this.defaultSeedTags().forEach(tag -> {
            if (!this.isOnlyIfLoaded()) {
                ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)tagAppender.apply((TagKey<Item>)tag)).m_255245_((Object)seed);
            } else {
                ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)tagAppender.apply((TagKey<Item>)tag)).m_176839_(BuiltInRegistries.f_257033_.m_7981_((Object)seed));
            }
        }));
    }

    @FunctionalInterface
    public static interface CommonOverride
    extends BiPredicate<BlockGetter, BlockPos> {
    }

    public static class LogsAndSticks {
        public List<ItemStack> logs;
        public final int sticks;

        public LogsAndSticks(List<ItemStack> logs, int sticks) {
            this.logs = logs;
            this.sticks = (Boolean)DTConfigs.DROP_STICKS.get() != false ? sticks : 0;
        }
    }
}

