/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen;

import com.ferreusveritas.dynamictrees.api.worldgen.GroundFinder;
import com.ferreusveritas.dynamictrees.systems.poissondisc.PoissonDisc;
import com.ferreusveritas.dynamictrees.util.LevelContext;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.worldgen.BiomeDatabase;
import com.ferreusveritas.dynamictrees.worldgen.BiomeDatabases;
import com.ferreusveritas.dynamictrees.worldgen.DynamicTreeFeature;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class CaveRootedTreeFeature
extends DynamicTreeFeature {
    @Override
    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockPos groundPos;
        WorldGenLevel level = context.m_159774_();
        ResourceLocation dimensionName = level.m_6018_().m_46472_().m_135782_();
        if (BiomeDatabases.isBlacklisted(dimensionName)) {
            return false;
        }
        BlockPos originPos = context.m_159777_();
        ChunkPos chunkPos = level.m_46865_(originPos).m_7697_();
        LevelContext levelContext = LevelContext.create((LevelAccessor)level);
        PoissonDisc disc = this.getDisc(levelContext, chunkPos, originPos).orElse(null);
        if (disc == null) {
            return false;
        }
        List<BlockPos> groundPositions = GroundFinder.getGroundFinder((Level)level.m_6018_()).findGround((LevelAccessor)level, originPos, null);
        if (groundPositions.isEmpty()) {
            return false;
        }
        BiomeDatabase.Entry biomeEntry = BiomeDatabases.getDefault().getEntry((Holder<Biome>)level.m_6018_().m_204166_(originPos));
        if (!biomeEntry.hasCaveRootedData()) {
            return false;
        }
        BiomeDatabase.CaveRootedData caveRootedData = biomeEntry.getCaveRootedData();
        BlockPos blockPos = groundPos = caveRootedData.shouldGenerateOnSurface() ? groundPositions.get(groundPositions.size() - 1) : (BlockPos)this.getNextGroundPos(originPos, groundPositions).orElse(null);
        if (groundPos == null || groundPos.m_123342_() - originPos.m_123342_() > caveRootedData.getMaxDistToSurface()) {
            return false;
        }
        DynamicTreeFeature.GeneratorResult result = this.generateTree(levelContext, biomeEntry, disc, originPos, groundPos, SafeChunkBounds.ANY_WG);
        return result == DynamicTreeFeature.GeneratorResult.GENERATED;
    }

    private Optional<PoissonDisc> getDisc(LevelContext levelContext, ChunkPos chunkPos, BlockPos originPos) {
        return DISC_PROVIDER.getPoissonDiscs(levelContext, chunkPos).stream().filter(disc -> disc.x == originPos.m_123341_() && disc.z == originPos.m_123343_()).findFirst();
    }

    private Optional<BlockPos> getNextGroundPos(BlockPos originPos, List<BlockPos> groundPositions) {
        for (BlockPos groundPos : groundPositions) {
            if (groundPos.m_123342_() <= originPos.m_123342_()) continue;
            return Optional.of(groundPos);
        }
        return Optional.empty();
    }
}

