/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.network.NodeInspector;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.block.leaves.DynamicLeavesBlock;
import com.ferreusveritas.dynamictrees.block.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.cell.LeafClusters;
import com.ferreusveritas.dynamictrees.data.DTBlockTags;
import com.ferreusveritas.dynamictrees.event.SpeciesPostGenerationEvent;
import com.ferreusveritas.dynamictrees.systems.genfeature.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.systems.nodemapper.CoderNode;
import com.ferreusveritas.dynamictrees.systems.nodemapper.CollectorNode;
import com.ferreusveritas.dynamictrees.systems.nodemapper.FindEndsNode;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.BlockStates;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.util.SimpleVoxmap;
import com.ferreusveritas.dynamictrees.worldgen.DynamicTreeFeature;
import com.ferreusveritas.dynamictrees.worldgen.GenerationContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JoCode {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String BASE_64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    protected static final byte FORK_CODE = 6;
    protected static final byte RETURN_CODE = 7;
    public byte[] instructions = new byte[0];
    protected boolean careful = false;
    private final byte[][] dirmap = new byte[][]{{0, 1, 2, 3, 4, 5, 6, 7}, {0, 1, 2, 3, 4, 5, 6, 7}, {0, 1, 2, 3, 4, 5, 6, 7}, {0, 1, 3, 2, 5, 4, 6, 7}, {0, 1, 5, 4, 2, 3, 6, 7}, {0, 1, 4, 5, 3, 2, 6, 7}};
    private byte[] facingMap = this.dirmap[2];
    private byte[] unfacingMap = this.dirmap[2];

    public JoCode(Level level, BlockPos rootPos, Direction facing) {
        this.getCodeFromWorld(level, rootPos, facing);
    }

    protected void getCodeFromWorld(Level level, BlockPos rootPos, Direction facing) {
        Optional<BranchBlock> branch = TreeHelper.getBranchOpt(level.m_8055_(rootPos.m_7494_()));
        if (branch.isPresent()) {
            CoderNode coder = new CoderNode();
            branch.get().analyse(level.m_8055_(rootPos), (LevelAccessor)level, rootPos, Direction.DOWN, new MapSignal(coder));
            this.instructions = coder.compile(this);
            this.rotate(facing);
        }
    }

    public JoCode(Level level, BlockPos pos) {
        this(level, pos, Direction.SOUTH);
    }

    public JoCode(String code) {
        this.instructions = JoCode.decode(code);
    }

    public JoCode setCareful(boolean c) {
        this.careful = c;
        return this;
    }

    protected int getCode(int pos) {
        return this.unfacingMap[this.instructions[pos]];
    }

    public JoCode setFacing(Direction facing) {
        int faceNum = facing.ordinal();
        this.facingMap = this.dirmap[faceNum];
        faceNum = faceNum == 4 ? 5 : (faceNum == 5 ? 4 : faceNum);
        this.unfacingMap = this.dirmap[faceNum];
        return this;
    }

    public JoCode rotate(Direction dir) {
        this.setFacing(dir);
        for (int c = 0; c < this.instructions.length; ++c) {
            this.instructions[c] = this.facingMap[this.instructions[c]];
        }
        return this;
    }

    public void generate(GenerationContext context) {
        LevelAccessor level = context.level();
        Species species = context.species();
        int radius = context.radius();
        boolean worldGen = context.safeBounds() != SafeChunkBounds.ANY;
        this.setFacing(context.facing());
        context.rootPos().m_122190_((Vec3i)species.preGeneration(level, context.rootPos(), radius, context.facing(), context.safeBounds(), this));
        BlockPos.MutableBlockPos rootPos = context.rootPos();
        if (rootPos == BlockPos.f_121853_) {
            return;
        }
        BlockState initialDirtState = level.m_8055_((BlockPos)rootPos);
        species.placeRootyDirtBlock(level, (BlockPos)rootPos, 0);
        this.generateFork(level, species, 0, (BlockPos)rootPos, false);
        BlockPos treePos = rootPos.m_7494_();
        BlockState treeState = level.m_8055_(treePos);
        BranchBlock firstBranch = TreeHelper.getBranch(treeState);
        if (firstBranch == null) {
            level.m_7731_((BlockPos)rootPos, initialDirtState, this.careful ? 3 : 2);
            return;
        }
        SimpleVoxmap leafMap = new SimpleVoxmap(radius * 2 + 1, species.getWorldGenLeafMapHeight(), radius * 2 + 1).setMapAndCenter(treePos, new BlockPos(radius, 0, radius));
        NodeInspector inflator = species.getNodeInflator(leafMap);
        FindEndsNode endFinder = new FindEndsNode();
        MapSignal signal = new MapSignal(inflator, endFinder);
        signal.destroyLoopedNodes = this.careful;
        firstBranch.analyse(treeState, level, treePos, Direction.DOWN, signal);
        if (signal.foundRoot || signal.overflow) {
            this.tryGenerateAgain(context, worldGen, treePos, treeState, endFinder);
            return;
        }
        this.generateAndAgeLeaves(context, leafMap, worldGen);
        List<BlockPos> endPoints = endFinder.getEnds();
        if (species.handleRot(level, endPoints, (BlockPos)rootPos, treePos, 0, context.safeBounds())) {
            return;
        }
        species.postGeneration(new PostGenerationContext(context, endPoints, initialDirtState));
        MinecraftForge.EVENT_BUS.post((Event)new SpeciesPostGenerationEvent(level, species, (BlockPos)rootPos, endPoints, context.safeBounds(), initialDirtState));
        this.addSnow(leafMap, level, (BlockPos)rootPos, context.biome());
    }

    protected void generateAndAgeLeaves(GenerationContext context, SimpleVoxmap leafMap, boolean worldGen) {
        BlockPos.MutableBlockPos cellPos;
        LevelAccessor level = context.level();
        Species species = context.species();
        LeavesProperties leavesProperties = species.getLeavesProperties();
        this.smother(leafMap, leavesProperties);
        for (SimpleVoxmap.Cell cell : leafMap.getAllNonZeroCells((byte)15)) {
            cellPos = cell.getPos();
            if (context.safeBounds().inBounds((BlockPos)cellPos, false)) {
                BlockState testBlockState = level.m_8055_((BlockPos)cellPos);
                if (!this.isReplaceable(testBlockState, true) && !testBlockState.m_204336_(BlockTags.f_13035_)) continue;
                level.m_7731_((BlockPos)cellPos, leavesProperties.getDynamicLeavesState(cell.getValue()), worldGen ? 16 : 2);
                continue;
            }
            leafMap.setVoxel((BlockPos)cellPos, (byte)0);
        }
        for (SimpleVoxmap.Cell cell : leafMap.getAllNonZeroCells()) {
            cellPos = cell.getPos();
            if (context.safeBounds().inBounds((BlockPos)cellPos, true)) continue;
            leafMap.setVoxel((BlockPos)cellPos, (byte)0);
        }
        TreeHelper.ageVolume(level, leafMap, species.getWorldGenAgeIterations(), context.safeBounds());
    }

    protected void tryGenerateAgain(GenerationContext context, boolean worldGen, BlockPos treePos, BlockState treeState, FindEndsNode endFinder) {
        if (worldGen) {
            if (!context.secondChanceRegen()) {
                LOGGER.debug("Non-viable branch network detected during world generation @ {}", (Object)treePos);
                LOGGER.debug("Species: {}", (Object)context.species());
                LOGGER.debug("Radius: {}", (Object)context.radius());
                LOGGER.debug("JoCode: {}", (Object)this);
            } else {
                LOGGER.debug("Second attempt for code {} has also failed", (Object)this);
            }
        }
        this.cleanupFrankentree(context.levelContext().accessor(), treePos, treeState, endFinder.getEnds(), context.safeBounds());
        if (!context.secondChanceRegen()) {
            context.secondChance();
            this.generate(context);
        }
    }

    protected void cleanupFrankentree(LevelAccessor level, BlockPos treePos, BlockState treeState, List<BlockPos> endPoints, SafeChunkBounds safeBounds) {
        HashSet<BlockPos> blocksToDestroy = new HashSet<BlockPos>();
        BranchBlock branch = TreeHelper.getBranch(treeState);
        MapSignal signal = new MapSignal(new CollectorNode(blocksToDestroy));
        signal.destroyLoopedNodes = false;
        signal.trackVisited = true;
        assert (branch != null);
        branch.analyse(treeState, level, treePos, null, signal);
        BranchBlock.destroyMode = DynamicTrees.DestroyMode.IGNORE;
        for (BlockPos pos : blocksToDestroy) {
            BlockState branchState;
            Optional<BranchBlock> branchBlock;
            if (!safeBounds.inBounds(pos, false) || (branchBlock = TreeHelper.getBranchOpt(branchState = level.m_8055_(pos))).isEmpty()) continue;
            int radius = branchBlock.get().getRadius(branchState);
            Family family = branchBlock.get().getFamily();
            Species species = family.getCommonSpecies();
            if (family.getPrimaryThickness() == radius) {
                species.getLeavesProperties().ifValid(leavesProperties -> {
                    SimpleVoxmap leafCluster = leavesProperties.getCellKit().getLeafCluster();
                    if (leafCluster != LeafClusters.NULL_MAP) {
                        for (SimpleVoxmap.Cell cell : leafCluster.getAllNonZeroCells()) {
                            BlockState leavesState;
                            BlockPos delPos = pos.m_121955_((Vec3i)cell.getPos());
                            if (!safeBounds.inBounds(delPos, false) || !TreeHelper.isLeaves(leavesState = level.m_8055_(delPos))) continue;
                            DynamicLeavesBlock leavesBlock = (DynamicLeavesBlock)leavesState.m_60734_();
                            if (leavesProperties.getFamily() != leavesBlock.getProperties(leavesState).getFamily()) continue;
                            level.m_7731_(delPos, BlockStates.AIR, 2);
                        }
                    }
                });
            }
            level.m_7731_(pos, BlockStates.AIR, 2);
        }
        BranchBlock.destroyMode = DynamicTrees.DestroyMode.HARVEST;
    }

    protected int generateFork(LevelAccessor level, Species species, int codePos, BlockPos pos, boolean disabled) {
        block4: while (codePos < this.instructions.length) {
            int code = this.getCode(codePos);
            switch (code) {
                case 6: {
                    codePos = this.generateFork(level, species, codePos + 1, pos, disabled);
                    continue block4;
                }
                case 7: {
                    return codePos + 1;
                }
            }
            Direction dir = Direction.m_122376_((int)code);
            pos = pos.m_121945_(dir);
            if (!disabled) {
                disabled = this.setBlockForGeneration(level, species, pos, dir, this.careful, codePos + 1 == this.instructions.length);
            }
            ++codePos;
        }
        return codePos;
    }

    protected boolean setBlockForGeneration(LevelAccessor level, Species species, BlockPos pos, Direction dir, boolean careful, boolean isLast) {
        if (this.isFreeToSetBlock(level, pos, species) && (!careful || this.isClearOfNearbyBranches(level, pos, dir.m_122424_()))) {
            species.getFamily().getBranchForPlacement(level, species, pos).ifPresent(branch -> branch.setRadius(level, pos, species.getFamily().getPrimaryThickness(), null, careful ? 3 : 2));
            return false;
        }
        return true;
    }

    protected boolean isFreeToSetBlock(LevelAccessor level, BlockPos pos, Species species) {
        if (DynamicTreeFeature.validTreePos((LevelSimulatedReader)level, pos) || level.m_7433_(pos, blockState -> blockState.m_204336_(BlockTags.f_13106_))) {
            return true;
        }
        BlockState blockState2 = level.m_8055_(pos);
        return blockState2.m_278721_() || this.isReplaceable(blockState2, false);
    }

    protected boolean isReplaceable(BlockState state, boolean airOnly) {
        boolean isEmpty = airOnly ? state.m_60795_() : state.m_247087_();
        return isEmpty || state.m_204336_(DTBlockTags.FOLIAGE) || state.m_204336_(BlockTags.f_13041_);
    }

    protected void smother(SimpleVoxmap leafMap, LeavesProperties leavesProperties) {
        int smotherMax = leavesProperties.getSmotherLeavesMax();
        if (smotherMax == 0) {
            return;
        }
        BlockPos saveCenter = leafMap.getCenter();
        leafMap.setCenter(new BlockPos(0, 0, 0));
        for (int startY = leafMap.getLenY() - 1; startY >= 0 && !leafMap.isYTouched(startY); --startY) {
        }
        for (int iz = 0; iz < leafMap.getLenZ(); ++iz) {
            for (int ix = 0; ix < leafMap.getLenX(); ++ix) {
                int count = 0;
                for (int iy = startY; iy >= 0; --iy) {
                    byte v = leafMap.getVoxel(new BlockPos(ix, iy, iz));
                    if (v == 0) {
                        count = 0;
                        continue;
                    }
                    if ((v & 0xF) != 0) {
                        if (++count <= smotherMax) continue;
                        leafMap.setVoxel(new BlockPos(ix, iy, iz), (byte)0);
                        continue;
                    }
                    if ((v & 0x10) == 0) continue;
                    ++count;
                    leafMap.setVoxel(new BlockPos(ix, iy + 1, iz), (byte)4);
                }
            }
        }
        leafMap.setCenter(saveCenter);
    }

    protected boolean isClearOfNearbyBranches(LevelAccessor level, BlockPos pos, Direction except) {
        for (Direction dir : Direction.values()) {
            if (dir == except || TreeHelper.getBranch(level.m_8055_(pos.m_121945_(dir))) == null) continue;
            return false;
        }
        return true;
    }

    protected void addSnow(SimpleVoxmap leafMap, LevelAccessor level, BlockPos rootPos, Holder<Biome> biome) {
        if (((Biome)biome.m_203334_()).m_47554_() >= 0.4f) {
            return;
        }
        block0: for (BlockPos.MutableBlockPos top : leafMap.getTops()) {
            if (!((Biome)level.m_203675_(rootPos.m_123341_() >> 2, rootPos.m_123342_() >> 2, rootPos.m_123343_() >> 2).m_203334_()).m_47519_((LevelReader)level, rootPos)) continue;
            BlockPos.MutableBlockPos iPos = new BlockPos.MutableBlockPos(top.m_123341_(), top.m_123342_(), top.m_123343_());
            int yOffset = 0;
            do {
                BlockState state;
                if ((state = level.m_8055_((BlockPos)iPos)).m_60795_()) {
                    level.m_7731_((BlockPos)iPos, Blocks.f_50125_.m_49966_(), 2);
                    continue block0;
                }
                if (state.m_60734_() == Blocks.f_50125_) continue block0;
                iPos.m_142448_(iPos.m_123342_() + 1);
            } while (yOffset++ < 4);
        }
    }

    public static String encode(byte[] array) {
        ArrayList<Byte> instructions = new ArrayList<Byte>(array.length + (array.length & 1));
        for (byte b : array) {
            instructions.add(b);
        }
        if ((instructions.size() & 1) == 1) {
            instructions.add((byte)7);
        }
        StringBuilder code = new StringBuilder();
        for (int b = 0; b < instructions.size(); b += 2) {
            code.append(BASE_64.charAt((Byte)instructions.get(b) << 3 | (Byte)instructions.get(b + 1)));
        }
        return code.toString();
    }

    public static byte[] decode(String code) {
        return new CodeCompiler(code).compile();
    }

    public String toString() {
        return JoCode.encode(this.instructions);
    }

    public Component getTextComponent() {
        return Component.m_237113_((String)this.toString()).m_130938_(style -> style.m_131140_(ChatFormatting.AQUA).m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, this.toString())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"chat.copy.click"))));
    }

    public static class CodeCompiler {
        final ArrayList<Byte> instructions;

        public CodeCompiler() {
            this.instructions = new ArrayList();
        }

        public CodeCompiler(int size) {
            this.instructions = new ArrayList(size);
        }

        public CodeCompiler(String code) {
            this.instructions = new ArrayList(code.length() * 2);
            for (int i = 0; i < code.length(); ++i) {
                int sixbits = JoCode.BASE_64.indexOf(code.charAt(i));
                if (sixbits == -1) continue;
                this.addInstruction((byte)(sixbits >> 3));
                this.addInstruction((byte)(sixbits & 7));
            }
        }

        public void addDirection(byte dir) {
            if (dir >= 0) {
                this.instructions.add((byte)(dir & 7));
            }
        }

        public void addInstruction(byte instruction) {
            this.instructions.add(instruction);
        }

        public void addReturn() {
            this.instructions.add((byte)7);
        }

        public void addFork() {
            this.instructions.add((byte)6);
        }

        public byte[] compile() {
            byte[] array = new byte[this.instructions.size()];
            Iterator<Byte> i = this.instructions.iterator();
            int pos = 0;
            while (i.hasNext()) {
                array[pos++] = i.next();
            }
            return array;
        }
    }
}

