/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.worldgen.structure;

import com.ferreusveritas.dynamictrees.worldgen.structure.DTCancelVanillaTreePoolElement;
import com.ferreusveritas.dynamictrees.worldgen.structure.TemplatePoolModifier;
import com.mojang.datafixers.util.Pair;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class RegularTemplatePoolModifier
implements TemplatePoolModifier {
    private final ResourceKey<StructureTemplatePool> key;
    private final StructureTemplatePool templatePool;

    private RegularTemplatePoolModifier(ResourceKey<StructureTemplatePool> key, StructureTemplatePool templatePool) {
        this.key = key;
        this.templatePool = templatePool;
    }

    @Override
    public TemplatePoolModifier replaceTemplate(int index, StructurePoolElement element) {
        if (this.templatePool.f_210559_.size() <= index) {
            return this;
        }
        Pair removedRawTemplate = (Pair)this.templatePool.f_210559_.remove(index);
        DTCancelVanillaTreePoolElement elementFinal = new DTCancelVanillaTreePoolElement(element, (StructurePoolElement)removedRawTemplate.getFirst());
        this.templatePool.f_210559_.add(index, Pair.of((Object)((Object)elementFinal), (Object)((Integer)removedRawTemplate.getSecond())));
        this.templatePool.f_210560_.replaceAll(template -> {
            if (template == removedRawTemplate.getFirst()) {
                return elementFinal;
            }
            return template;
        });
        return this;
    }

    @Override
    public TemplatePoolModifier removeTemplate(int index) {
        Pair removedRawTemplate = (Pair)this.templatePool.f_210559_.remove(index);
        this.templatePool.f_210560_.removeIf(template -> template == removedRawTemplate.getFirst());
        return this;
    }

    @Override
    public void removeAllTemplates() {
        this.templatePool.f_210559_.clear();
        this.templatePool.f_210560_.clear();
    }

    @Override
    public void registerPool(BootstapContext<StructureTemplatePool> context) {
        context.m_255272_(this.key, (Object)this.templatePool);
    }

    public static TemplatePoolModifier village(HolderLookup.Provider lookupProvider, String type, String patternGroup) {
        ResourceLocation patternName = new ResourceLocation("village/" + type + "/" + patternGroup);
        return RegularTemplatePoolModifier.create(lookupProvider, (ResourceKey<StructureTemplatePool>)ResourceKey.m_135785_((ResourceKey)Registries.f_256948_, (ResourceLocation)patternName));
    }

    public static TemplatePoolModifier create(HolderLookup.Provider lookupProvider, ResourceKey<StructureTemplatePool> key) {
        StructureTemplatePool pattern = (StructureTemplatePool)lookupProvider.m_255025_(Registries.f_256948_).m_255043_(key).m_203334_();
        return new RegularTemplatePoolModifier(key, new StructureTemplatePool(pattern.m_254935_(), pattern.f_210559_));
    }
}

